/**
  Copyright (c) 2012 Freescale Semiconductor
  
  \file       mc_tui_test.c
  \brief      This file contains the animations
  \author     Freescale Semiconductor
  \author     Automotive Systems Solutions Engineering
  \author     DB, r54930
  \version    1.0
  \date       16/Feb/2014
  
  * History:  16/Feb/2014- Initial Version

* Copyright (c) 2014, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/

#include "common.h"
#include "..\HIL\Graphics.h"
#include "..\HIL\Display.h"
#include "..\HIL\Flib.h"
#include "..\HAL\GALLO.h"
#include "..\SERVICES\DMAHandler.h"
#include "..\HIL\FontLibrary.h"
#include "mc_parameters.h"
#include "..\src\FSLtime.h"
//  TUI
#include "tiny_ui.h"
#include "tiny_ui_util.h"
#include "tiny_ui_platform.h"
#include "tiny_ui_util_nOS.h"
// Image objects
#include "..\PICTURES\testImg565.h"
#include "..\PICTURES\test32bpp.h"
// Fonts
#include "..\FONTS\ARIAL34.h"
#include "..\FONTS\ARIAL30.h"


/************/
/*  Defines */
/************/

/***********************************/
// ********  Constants  ************
/**********************************/

/********************/
/* Global Variables */
/********************/
    mc_tui_test_paramters_t mc_tui_test_paramters;
    tiny_ui_buffer_t tuit_frmBuf[2];
    tiny_ui_buffer_t * tuit_pBuf = NULL;
    tiny_ui_matrix_t tuit_matrix;
    tiny_ui_buffer_t tuit_srcImage, tuit_srcImage2;
    void * tuit_pAddr;   
    Graphics_Object_t tuit_RAMGO =
    {
        (uint32_t)0,200,200,NULL_PTR,0x00,0,GRAPHICS_565RGB,255,0xFF0000,0x0, (GRAPHICS_CODING_RAWINT),0,0,(void *)0
    };
    extern uint32_t Timing[16];
    tiny_ui_float_t Zoom = 1.0f;
    tiny_ui_float_t Zoomfactor;
/*********************************/
/* Function prototypes ***********/
/*********************************/
extern void tui2go(Graphics_Object_t *dst, tiny_ui_buffer_t *src);
/*******************************/
/*  Code starts Here           */
/*******************************/
void mc_tui_test(uint32_t CurrentFrame)
{
    uint32_t relative_fr;
    uint32_t i;
    tiny_ui_error_t error;
    
    if(mc_tui_test_properties.frameLatch == 0u)
    {
        mc_tui_test_properties.frameLatch = CurrentFrame;
    }
    relative_fr = CurrentFrame - mc_tui_test_properties.frameLatch;
    
   
    switch(relative_fr)
    {
      case 0: //init stuff
        //allocate draw buffers
        tuit_frmBuf[0].width	= 200;
        tuit_frmBuf[0].height = 200;
        tuit_frmBuf[0].stride = 400;
        tuit_frmBuf[0].format = TINY_UI_RGB565;
        error = tiny_ui_allocate(&tuit_frmBuf[0]);
        if (error) while(1);

        tuit_frmBuf[1].width	= 400;
        tuit_frmBuf[1].height = 320;
        tuit_frmBuf[1].stride = 1600;
        tuit_frmBuf[1].format = TINY_UI_RGBA8888;
        error = tiny_ui_allocate(&tuit_frmBuf[1]);
        tuit_frmBuf[1].address = 0x3F400000;
        tuit_frmBuf[1].memory = (void *)0x3F400000;
        if (error) while(1);

        //setup source image
        tuit_srcImage.address = testImg565_GObjectArray[0]->address;
        tuit_srcImage.height = testImg565_GObjectArray[0]->height;
        tuit_srcImage.width = testImg565_GObjectArray[0]->width;
        tuit_srcImage.format = TINY_UI_RGB565;
        tuit_srcImage.handle = NULL_PTR;
        tuit_srcImage.stride = testImg565_GObjectArray[0]->width * 2;
        tuit_srcImage.memory = (void *)testImg565_GObjectArray[0]->address;

        tuit_srcImage2.address = test32bpp_GObjectArray[0]->address;
        tuit_srcImage2.height = test32bpp_GObjectArray[0]->height;
        tuit_srcImage2.width = test32bpp_GObjectArray[0]->width;
        tuit_srcImage2.format = TINY_UI_RGBA8888;
        tuit_srcImage2.handle = NULL_PTR;
        tuit_srcImage2.stride = test32bpp_GObjectArray[0]->width * 4;
        tuit_srcImage2.memory = (void *)test32bpp_GObjectArray[0]->address;
        //Init 2D-ACE Layers
        tuit_RAMGO.address = tuit_frmBuf[0].address; 
        Display_InitLayer(TUI_TEST_BUFFER0,&tuit_RAMGO,0,160);
        tui2go(&tuit_RAMGO, &tuit_frmBuf[1]);
        Display_InitLayer(TUI_TEST_BUFFER1,&tuit_RAMGO,400,80);          

        break;
      default:  // Draw loop
        if (Zoom >= 1.0f) Zoomfactor = -0.05;
        else if (Zoom <= 0.4f) Zoomfactor = 0.05;
        Zoom += Zoomfactor;
        
        Timing[0]=FSLtime.ms;
        Timing[1]= var32_read(PIT_CVAL1) / 66;
        tiny_ui_clear(&tuit_frmBuf[0], NULL, 0xFF000000);
        tiny_ui_clear(&tuit_frmBuf[1], NULL, 0xFF000000);
        tiny_ui_Identity(&tuit_matrix);
        //tiny_ui_Translate(100, 100, &matrix);
        tiny_ui_Scale(Zoom, Zoom, &tuit_matrix);
        tiny_ui_Rotate(Zoom * 20.0f, &tuit_matrix);
        //tiny_ui_Translate(-100, -100, &tuit_matrix);
        Timing[2]=FSLtime.ms;
        Timing[3]= var32_read(PIT_CVAL1) / 66;
        error = tiny_ui_blit(&tuit_frmBuf[0], &tuit_srcImage, &tuit_matrix, TINY_UI_BLEND_NONE, 0);
        if (error) while(1); // ugly debug stop
        Timing[4]=FSLtime.ms;
        Timing[5]= var32_read(PIT_CVAL1) / 66;
        error = tiny_ui_blit(&tuit_frmBuf[1], &tuit_srcImage2, &tuit_matrix, TINY_UI_BLEND_NONE, 0);
        if (error) while(1); // ugly debug stop        
        Timing[6]=FSLtime.ms;
        Timing[7]= var32_read(PIT_CVAL1) / 66;
        Timing[8]= Timing[5] - Timing[7] + ((Timing[6] - Timing[4]) * 1000);
        
      break;
    }
}
/**********************************************/
void mc_tui_test_Dispose()
{
	
}

void mc_tui_test_Refresh()
{

}
